//Program to find out fault current,post-fault voltages and line flow of a given network//
//This program requires user input. A sample problem with user input and output is available in the result files. Question is available in the file "SymmetricalFaultQuestionFile.jpg" and result is available in the file "SymmetricalFaultResultFile.jpg"//
//Scilab Version 5.5.2 ; OS:Windows
clc;
clear;
linedata=input('enter the line data values in the order of starting bus,nding bus,resistance and reactance:')
f=input('enter the bus at wich fault occurs:')  
bv=input('enter the pre-fault bus voltage:')  
sb=linedata(:,1)  //Starting bus number of all the lines stored in variable sb //
eb=linedata(:,2)  //Ending bus number of all the lines stored in variable eb //
z=linedata(:,3)+linedata(:,4)*%i  //lineimpedance=R+jX //
zbus=[];
check=[];
for i=1:length(sb)  //starting of impedance matrix calculation part//
    m=sb(i);
    n=eb(i);
    mn=min(m,n);
    nm=max(m,n);
    ncheck=length(find(check==nm));
    mcheck=length(find(check==mn));
    [rows columns]=size(zbus);
    if mn==0 & ncheck==0 
        zbus=[zbus zeros(rows,1);zeros(1,rows) z(i)];
        check=[check nm];
         else if mcheck>0 & ncheck==0
            zbus=[zbus zbus(:,mn);zbus(mn,:) zbus(mn,mn)+z(i)];
            check=[check nm];
            elseif mn==0 & ncheck>0
            zbus=[zbus zbus(:,nm);zbus(nm,:) zbus(nm,nm)+z(i)];
            zbusn=zeros(rows,rows);
            for r=1:rows
                for t=1:columns
                    zbusn(r,t)=zbus(r,t)-(zbus(r,rows+1)*zbus(rows+1,t))/(zbus(rows+1,rows+1));
                end
            end
            zbus=zbusn
        elseif mcheck>0 & ncheck>0
            zbus=[zbus zbus(:,nm)-zbus(:,mn);zbus(nm,:)-zbus(mn,:),z(i)+zbus(mn,nm)+zbus(nm,nm)-2*zbus(nm,mn)];
            zbusn=zeros(rows,rows);
            for r=1:rows
                for t=1:columns
                   zbusn(r,t)=zbus(r,t)-(zbus(r,rows+1)*zbus(rows+1,t))/(zbus(rows+1,rows+1)); 
               end
           end
           zbus=zbusn;
       end
   end
end   //ending of impedance bus matrix calculation part// 
disp(zbus,'the impedance matrix is:');
ifa=bv/zbus(f,f)  //calculation of fault current//
disp(ifa,'the fault current is:')
disp('the post fault voltages v1,v2,v3 respectively are:');
for i=1:n
v(i)=bv-(ifa*zbus(i,f)); //calculation of postfault bus voltages//
disp(v(i));
end
a=input('enter the starting bus to calculate the line flow:');
b=input('enter the ending bus to calculate the line flow:');
zs=input('enter the impedance between the above buses:');
i13=(v(a)-v(b))/zs; //calculation oflineflows//
disp(i13,'the line flow current is:')

//SAMPLE INPUT and OUTPUT: 
//enter the line data values in the order of starting bus,nding bus,resistance and reactance:[0 1 0 1.5;1 2 0 0.2;2 3 0 0.15;3 0 0 1.5;1 3 0 0.3]
//enter the bus at wich fault occurs:2
//enter the pre-fault bus voltage:1
 
// the impedance matrix is:   
 
//    0.7745830i    0.7464881i    0.7254170i  
//    0.7464881i    0.8362160i    0.7535119i  
//    0.7254170i    0.7535119i    0.7745830i  
 
// the fault current is:   
 
//  - 1.1958633i  
 
// the post fault voltages v1,v2,v3 respectively are:   
 
//    0.1073022  
 
//    0  
 
//    0.0989028  
//enter the starting bus to calculate the line flow:1
//enter the ending bus to calculate the line flow:3
//enter the impedance between the above buses:0.3*%i
 
// the line flow current is:   
 
//  - 0.0279980i  



